/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LoggingFormatter
extends Formatter {
    private static final Logger log = Logger.getLogger(LoggingFormatter.class.getName());
    private static String lineSeparator = "\n";

    @Override
    public String format(LogRecord record2) {
        StringBuffer sb = new StringBuffer(128);
        sb.append('[').append(Thread.currentThread().getName()).append("] ");
        Date date = new Date(record2.getMillis());
        sb.append(date.toString()).append(' ');
        sb.append('[').append(record2.getLevel().getLocalizedName()).append("] ");
        if (record2.getSourceClassName() != null) {
            sb.append(record2.getSourceClassName());
        } else {
            sb.append(record2.getLoggerName());
        }
        if (record2.getSourceMethodName() != null) {
            sb.append(' ');
            sb.append(record2.getSourceMethodName());
        }
        sb.append(':').append(lineSeparator);
        sb.append(this.formatMessage(record2)).append(lineSeparator);
        if (record2.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record2.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        sb.append(lineSeparator);
        return sb.toString();
    }

    public static void main(String[] args2) {
        log.info("Info Event");
        log.severe("Severe Event");
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                log.info("Info Event in Thread");
            }
        }, "Thread into main");
        t.start();
        log.log(Level.SEVERE, "exception", new Exception());
    }

    static {
        try {
            String separator = System.getProperty("line.separator");
            if (separator != null && separator.trim().length() > 0) {
                lineSeparator = separator;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

